import { Text, View } from "react-native";
import React from "react";
import { itemDetailsStyles } from "../ItemDetailsStyle";
import { B2bPricesStyles } from "./B2bPrices";
import { StyleSheet } from "react-native";
import usePreferences from "../../../../../../hooks/usePreferences";
import { getMinMaxSale } from "../../../../../../helper/variantPrice";

const RegularItemPrice = ({price, type, selectedVariation, b2b, width}) => {
    const {
        preference: {
            symbol_position
        } = {},
        company: { dflt_currency_symbol } = {},
    } = usePreferences();
    const formattedPrice = (price?.salePrice && (getMinMaxSale(price, symbol_position, dflt_currency_symbol)));
    const { salePrice, regularPrice } = price || {};
    const { 
        success,
        value: { 
            isEnableB2B: selectedIsEnableB2B,
        } = {}
    } = selectedVariation || {};
    const {isEnableB2B} = b2b || {};
  return (
    <View style={RegularItemPriceStyle.cont(width)}>
        <View style={itemDetailsStyles.priceCont}>
            {(salePrice || regularPrice) && (
                <Text style={itemDetailsStyles.price}>
                    {type === 'Variable Product' ? formattedPrice || salePrice || regularPrice : salePrice || regularPrice}
                </Text>
            )}
            {type !== 'Variable Product' && salePrice && regularPrice && (
                <Text style={itemDetailsStyles.discount}>{regularPrice}</Text>
            )}
            {success && salePrice && regularPrice && (
                <Text style={itemDetailsStyles.discount}>{regularPrice}</Text>
            )}
        </View>
        {type == 'Simple Product' && (selectedIsEnableB2B == 1 || isEnableB2B == 1) && <Text style={B2bPricesStyles.qty}>Min. Order: 1 Piece</Text>}
        {type == 'Variable Product' && success && (selectedIsEnableB2B == 1 || isEnableB2B == 1) && <Text style={B2bPricesStyles.qty}>Min. Order: 1 Piece</Text>}
    </View>
  );
};

export default RegularItemPrice;

const RegularItemPriceStyle = StyleSheet.create({
    cont: (width) => ({
        width: width,
    })
})
